/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'hbs!modules/patient-context/patientContext' ],
    function (Portal, Backbone, Marionette, $, jqm, template) {
    return Backbone.Marionette.ItemView.extend({
        initialize: function () {
            _.bindAll(this);
            Portal.vent.on('hide:patient', this.hidePatientContext);
            Portal.vent.on('show:patient', this.showPatientContext);
        },
        tagName: 'div',
        model: Portal.patient(), //yet another reason marionette and jQM is so questionable
        template: template,
        modelEvents: {
            'sync': 'render unhide'
        },
        hidePatientContext: function () {
            this.$el.hide();
        },
        showPatientContext: function () {
            this.$el.show();
        },
        onRender: function(){
            this.$el.trigger("refresh");
        },
        unhide: function(){
            $("#patient-context").removeAttr("style");
        }
    });
});
